///////////////////////////////////////////////////////////////////////////////////
//No part of this file can be copied or released without the consent of 
//Avalanche Technology
//										
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//										
//	Avalanche Technology Inc., Proprietary and Confidential	   *
//										
// 	Release:  3.0    Date 6/7/2023  	
//							
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//  PART DESCRIPTION:
//
//  Technology: 22nm pMTJ STT-MRAM
//  Part:       AS3001316/AS3004316/AS3008316/AS3016316/AS3032316/AS3064316
//
//  Description: 1/4/8/16/32/64 MEGABIT PARALLEL PERSISTENT SRAM MEMORY
//
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//  FILE CONTENTS : STIMULUS for Testbench
//
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// MODULE DECLARATION                                                             //
////////////////////////////////////////////////////////////////////////////////////

`timescale 1ns/1ps

module stimulus (
	output reg En,
	output reg Wn,
  output reg UBn,
  output reg LBn,

	output reg [21:0] ADDR,
	inout [15:0] DQ,
 	output reg Gn
	);

reg [15:0] DQ_reg;
reg out_en;

`include "./task.v"

assign DQ = out_en ? DQ_reg : 32'hz;

initial begin
  En = 1'b1;
  Wn = 1'b1;
  Gn = 1'b1;
  ADDR = 0;
  DQ_reg = 0;
  out_en = 0;
  UBn = 0; //Enabled
  LBn = 0; //Enabled
end

initial begin
    #100;

    /*$display("Write Read Sequence");
    WriteReadCheck();*/

    $display("==== [TEST] Write ====");
    WriteRelTime(22'h100, 16'h0101, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    WriteRelTime(22'h200, 16'h0202, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    WriteRelTime(22'h300, 16'h0303, 8'd0,8'd0,8'd13,8'd15,8'd0,8'd17);
    ReadRelTime(22'h100,16'h0101, 8'd0,8'd20,8'd25,8'd0,8'd1);
    #10;
    WriteRelTime(22'h400, 16'h0404, 8'd0,8'd0,8'd13,8'd15,8'd0,8'd17);
    WriteRelTime(22'h500, 16'h0505, 8'd0,8'd0,8'd13,8'd15,8'd0,8'd17);
    ReadRelTime(22'h200,16'h0202, 8'd0,8'd20,8'd25,8'd0,8'd1);
    #10;
    $display("==== [TEST] Read Upper/Lower via UBn/LBn ====");
    {UBn, LBn} = 2'b10;
    ReadRelTime(22'h500,16'h0505, 8'd0,8'd20,8'd25,8'd0,8'd1);
    #10;
    {UBn, LBn} = 2'b01;
    ReadRelTime(22'h400,16'h0404, 8'd0,8'd20,8'd25,8'd0,8'd1);
    #10;
    {UBn, LBn} = 2'b11;
    ReadRelTime(22'h300,16'h0303, 8'd0,8'd20,8'd25,8'd0,8'd1);
    #50;
    {UBn, LBn} = 2'b00;
    ReadRelTimeEnTrig(22'h100,16'h0101, 8'd0,8'd0,8'd45,8'd0,8'd1);
    #100;
    $display("==== [TEST] Write prevented by UBn/LBn ====");
    {UBn, LBn} = 2'b11;
    WriteRelTime(22'h300, 16'hffff, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    {UBn, LBn} = 2'b00;
    ReadRelTime(22'h300,16'h0303, 8'd0,8'd20,8'd25,8'd0,8'd1);
    #10;
    
    $display("==== [TEST] UBn test ====");
    {UBn, LBn} = 2'b00;
    WriteRelTime(22'h100, 16'h1111, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    {UBn, LBn} = 2'b11;
    ADDR = 22'h100;
    #10 En = 0;
    #10 Wn = 0;
    UBn = 0;
    DQ_reg = 16'hffff;
    out_en = 1'b1;
    #25 
    Wn = 1'b1;
    En = 1'b1;
    UBn = 1'b1;
    #15
    out_en = 0;
    #50
    {UBn, LBn} = 2'b00;
    ReadRelTime(22'h100,16'hff11, 8'd0,8'd20,8'd25,8'd10,8'd1);
    #100;
    
    $display("==== [TEST] LBn test ====");
    {UBn, LBn} = 2'b00;
    WriteRelTime(22'h200, 16'h2222, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    {UBn, LBn} = 2'b11;
    ADDR = 22'h200;
    #10 En = 0;
    #10 Wn = 0;
    LBn = 0;
    DQ_reg = 16'hffff;
    out_en = 1'b1;
    #25 
    Wn = 1'b1;
    En = 1'b1;
    LBn = 1'b1;
    #15
    out_en = 0;
    #50
    {UBn, LBn} = 2'b00;
    ReadRelTime(22'h200,16'h22ff, 8'd0,8'd20,8'd25,8'd10,8'd1);
    #100;
    


    $finish();
end

endmodule
